/*
    This script class allows to remote control 'Hard Disk Ogg' which is a freeware
    wave recording tool.
    It uses the sound card of your computer and records from any input you specify for it.
    
    The class assumes that two files are present in the directory where the main executed script 
    resides:
    - MemBrain.hdp
    and
    - MemBrain.hfs
    
    Both files can be created through the Hard Disk Ogg User Interface after setting up 
    Hard Disk Ogg for your system.
*/


#include "SecondsTimer.as"

const string HDOGG_INSTALL_PATH = "C:\\hdogg";

const string HDOGG_EXE = HDOGG_INSTALL_PATH + "\\Harddisk.exe";
const string HDOGG_START_PARMS = "-minimize -overwrite -nofocus -silent"; // -sequential


class WaveRecorder
{
    // Initialize the module and lainch the wave recorder app
    void Init()
    {
        string workDir;
        string parmStr = HDOGG_START_PARMS;
        
        GetWorkDir(workDir);
        parmStr += " -preset \"" + workDir + "\\MemBrain.hdp" + "\"";
        parmStr += " -filter  \"" + workDir + "\\MemBrain.hfs" + "\"";
        
        if (DEBUG) Trace(parmStr);
        
        ShellExecute("open", HDOGG_EXE, parmStr);
        
        Sleep(2000);
    }
    
    // Start recording to the given path/file.
    // Parameter 'timeout specifies an automatic stop of the recorder after recording for the specified '
    // time.
    // If 0 then recording does not stop automatically
    void Start(string &in filePath, uint timeLimitSeconds)
    {
        string parmStr;
        
        if (timeLimitSeconds == 0)
        {
            parmStr = "-record -output \"" + filePath + "\"";
        }
        else
        {
            string timeLimitStr = timeLimitSeconds;
            
            parmStr = "-record -timelimit " + timeLimitStr + " -output \"" + filePath + "\"" ;
        }
        if (DEBUG) Trace(parmStr + "\n");
        ShellExecute("open", HDOGG_EXE, parmStr);
    }
    
    // Cuts to next file immediately
    void Cut(string newOutPath)
    {
        string parmStr = "-cut -output \"" + newOutPath + "\"" ;
        
        if (DEBUG) Trace(parmStr + "\n");
        ShellExecute("open", HDOGG_EXE, parmStr);
    }
    
    // Stop recording
    void Stop()
    {
        ShellExecute("open", HDOGG_EXE, "-stop");
    }
    
    // Shutdown the wave recorder app
    void Shutdown()
    {
        ShellExecute("open", HDOGG_EXE, "-quit");
    }
}