// Maximum coordinate value
const uint16 MAX_COORDINATE = 30000;

class Position
{
    // Default constructor
    Position()
    {
        x = 0;
        y = 0;
    }
    
    // Constructor for initial valid position
    Position(uint16 initX, uint16 initY)
    {
        x = ClipCoordinate(initX);
        y = ClipCoordinate(initY);
    }
    
    void Set(uint16 newX, uint16 newY)
    {
        x = ClipCoordinate(newX);
        y = ClipCoordinate(newY);
    }
    
    void Move(int16 dX, int16 dY)
    {
        uint16 newX = x + dX;
        uint16 newY = y + dY;
        
        x = ClipCoordinate(newX);
        y = ClipCoordinate(newY);
    }
    
    // Clip the given coordinate to valid limits 0 .. MAX_COORDINATE
    uint16 ClipCoordinate(int16 coor)
    {
        uint16 c;
        
        if (coor > MAX_COORDINATE)
        {
            c = MAX_COORDINATE;
        }
        else if (coor < 0)
        {
            c = 0;
        }
        else
        {
            c = coor;
        }
        
        return c;
    }
    
    
    // The position variables
    uint16 x;
    uint16 y;
}
