// Overall recording duration per participant during training [s]
const uint OVERALL_REC_SECONDS_PER_PARTICIPANT = 10;

// Overall recording duration per detection cycle during detection [s]
const uint OVERALL_REC_SECONDS_FOR_DETECTION = 2;

// The participants for the voice recognition session
const string[] PARTICIPANTS = 
{
    "Nobody",
    "Voice 1",
    "Voice 2",
    "Voice 3"
};


// The hidden layers with their neuron count
const uint16[] HID_LAYERS = 
{
    5,
    7
};

// Print debug messages?
const bool DEBUG = false;

// Sample frequency in [Hz] (as adjusted in the recording settings of hard disk ogg)
const uint SAMPLE_FREQ = 16000;

// Length of a single sample snippet [ms]
const uint SNIPPET_LEN_MS = 2000;

// The input dimension for the net
const uint INPUT_DIMENSION = 40;

// Target net error for teaching
const double TARGET_NET_ERROR = 0.001;

// Sub directory for storing the data of all participants
const string PARTICIPANT_DIR = "ParticipantDatabase";

// Time interval for changing the displayed output on the pattern error viewer [s]
const uint PATTERN_ERR_VIEWER_TOGGLE_SECONDS = 3;

// The wave file name to use for recording
const string WAVE_FILE_NAME = "Sample.wav";

// Name of the training lesson
const string TRAIN_LESSON_NAME = "Train.mbl";

// Name of temporary lesson file
const string TEMP_LESSON_NAME = "Temp.mbl";

// Name of the neural net
const string NET_NAME = "VoiceRecognition.mbn";



