/*
This is a simple example script file to demonstrate how MemBrain scripts can be used to train and validate a net.
Note that this example just is a translation of the old known scripting example into the new MemBrain scripting
language that is now based on AngelScript.
Thus, this example does not contain any variables or loops or things like that since these kind of things
have not been available with former MemBrain versions.
*/

void main()
{
	// Adjust the view
	ViewSetting(BLACK_BG, true);
	ViewSetting(SHOW_GRID, false);
	ViewSetting(UPDATE_TEACH, true);
	ViewSetting(UPDATE_THINK, true);
	ViewSetting(SHOW_FIRE, false);
	ViewSetting(SHOW_ACT_SPIKES, false);
	ViewSetting(SHOW_LINKS, true);

	OpenNet("Decoder4To16.mbn"); 		// Open the net to be trained and validated
	RandomizeNet();						// Randomize all link weights and activation thresholds.
	ResetThinkSteps();					// Reset the think step counter
	SetLessonCount(1);					// Delete all lessons except for #1
	/*
	This script uses four lessons in the Lesson Editor (create them now).
	As a net is already loaded the new lessons will be created in sync with the net
	(same I/O names).
	*/
	SetLessonCount(4);
	SelectLesson(1);					// First operate on Lesson #1

	LoadLesson("Decoder4To16_Training.mbl");	// Load training lesson
	ShowLessonEditor(false);					// Hide the lesson editor again to fully view the net

	/*
	Set the teacher to be used. This script uses the currently active teacher of MemBrain, thus, the line
	is commented out. Use the name of the teacher you want to set as the active one instead here if you want to
	ensure that a certain teacher is used.
	*/
	//SelectTeacher("RPROP");			// Use the teacher with the name 'BP'

	// Adjust the teacher
	TeacherSetting(LEARNRATE, 0.1);		// The learning rate

	TeacherSetting(TARGET_ERR, 0.3);	// The target net error

	TeacherSetting(LESSON_REPS, 1);		// Lesson repetitions per teach step,
	TeacherSetting(PATTERN_REPS, 1);	// Pattern repetitions per teach step,
	TeacherSetting(PATTERN_SELECT, RAND_ORDER); // The pattern selection method

	SetTeachSpeed(0);					// Set maximum teach speed

	ShowErrorViewer(true);				// Show the net error viewer and reset it
	ResetErrorViewer();

	StartTeaching();					// Start teaching and wait for stop (target error reached)
	SleepExec();

	ShowErrorViewer(false);				// Hide the error viewer again
	ResetThinkSteps();					// Reset think step counter

	// Now prepare lesson #3 to record the output of the net
	SetRecordingType(RT_ACT);			// Record activation values of output neurons
	StartRecording(3);					// Enable recording of data to lesson #3

	ShowLessonEditor(false);			// Hide the lesson editor

	SetThinkSpeed(500);					// 500ms between think steps for animation

	// First record network reaction on training data to lesson #3
	ThinkLesson();						// Think on every pattern in lesson #1 (and record to #3)
	SleepExec();						// Wait until 'Think on Lesson' is finished

	StopRecording();					// Deactivate recording again


	SelectLesson(2);					// Load lesson #2 with the validation data
	// ImportLessonRaw("Decoder4To16_Validate.csv");
	// Could also import a lesson (see line above but the imported file has to use country
	// specific characters for list separation (; or ,) and for decimal point (. or ,)
	LoadLesson("Decoder4To16_Validate.mbl");
	EnableLessonOutData(false);			// Don't need any output data, this lesson is input only

	SetRecordingType(RT_ACT);			// Record activation values of output neurons
	StartRecording(4);					// Enable recording of data to lesson #4

	ShowLessonEditor(false);			// Hide the lesson editor

	ThinkLesson();						// Think on every pattern in lesson #2 (and record to #4)
	SleepExec();						// Wait until 'Think on Lesson' is finished

	StopRecording();					// Deactivate recording again

	// Now export lesson #3 and 4 to csv
	SelectLesson(3);
	ExportLessonRaw("Decoder4To16_TrainResult.csv");
	SelectLesson(4);
	ExportLessonRaw("Decoder4To16_ValidateResult.csv");


	// Adjust for maximum speed again
	SetThinkSpeed(0);

	// Uncomment the following line if you want MemBrain to terminate after the script execution
	// ExitMemBrain();
}










