#include "SecondsTimer.as"



/*
Example that uses the timers. The only effect of this example is that it 
runs for 10 s and prints debug messages to the trace window every time a timer 
elapses or is started.
The debug messages are actually printed in the SecondsTimer implementation 
(file 'SecondsTimer.as')
*/
void main()
{
	int TMR0_TARGET_TIME = 10;
	uint TMR1_INTERVAL = 1;
	
	// Create two timers. The timers are created with an interval already which means
	// they are automatically started during creation.
	// Could also create the timers without specifying an interval and start them 
	// later.
    SecondsTimer timer0;
	SecondsTimer timer1(TMR1_INTERVAL);

	while (timer0.SecondsSinceStart() < TMR0_TARGET_TIME)
	{ // This loop will run for TMR0_TARGET_TIME seconds and then terminate
		if (timer1.IsElapsed())
		{ // timer 1 is immediately restarted every time it elapses. The only 
			timer1.Start(TMR1_INTERVAL);
		}
		// Do not run in a loop at full speed, will eat computing power needed for MemBrain
		// itself and for other running programs.
		// --> Let script sleep some time instead...
		Sleep(100);
	}
}



