/*------------------------------------------------------------------------------------------------------------
This example demonstrates how the script function Now() can be used to maintain an arbitrary number of timers
with a resolution of 1s.

To use the timers in your own script just include this file into your script using the #include directive.
Then create an instance of the class 'SecondsTimer' for every timer you need. 

Note that the timer functions contain debug code that prints messages to MemBrain's trace window. You can
remove the corresponding code if you don't want any messages to be printed by the timer functions.
------------------------------------------------------------------------------------------------------------*/

// Global variable to count the instances of the class. Only used to generate debug messages.
// AngelScript does not yet support static class members. That's why this has to be a global variable.
uint gSecondsTimerInstanceCount = 0;

class SecondsTimer
{
    // Constructor without arguments
    SecondsTimer()
    {
       mId = gSecondsTimerInstanceCount++;
       mReferenceTime = Now();
    }
    
    // Constructor with initial elapse time [s]
    SecondsTimer(uint seconds)
    {
        mId = gSecondsTimerInstanceCount++;
        // Get current time, add elapse seconds and store the resulting elapse time.
        int now = Now();
        
        mReferenceTime = now + seconds;
        
        // For debug purposes only:
        string	timeStr;
        TimeToString(now, timeStr);
        Trace(timeStr);
        TimeToString(mReferenceTime, timeStr);
        Trace(" Timer  " + mId + " started. Will elapse at:" + timeStr + "\n");
    }
    
    ~SecondsTimer()
    {
        gSecondsTimerInstanceCount--;
    }
    
    // Check if the timer is elapsed
    bool IsElapsed()
    {
        int now = Now();
    	bool elapsed = now >= mReferenceTime;
    
    	// For debug purposes only:
    	if (elapsed)
    	{
    		string	timeStr;
       	 	TimeToString(now, timeStr);
    	 	Trace(timeStr);
    	 	Trace(" Timer " + mId + " elapsed\n");
    	}
      	return elapsed;
    }
    
    // Start the timer to elapse after the given time
    void Start(uint seconds)
    {
        // Get current time, add elapse seconds and store the resulting elapse time.
        int now = Now();
        
        mReferenceTime = now + seconds;
        
        // For debug purposes only:
        string	timeStr;
        TimeToString(now, timeStr);
        Trace(timeStr);
        TimeToString(mReferenceTime, timeStr);
        Trace(" Timer  " + mId + " started. Will elapse at:" + timeStr + "\n");
    }
    
    // Start the timer to just count seconds
    void Start()
    {
        // Get current time, set elapse time to the same value.
        int now = Now();
        
        mReferenceTime = now;
        
        // For debug purposes only:
        string	timeStr;
        TimeToString(now, timeStr);
        Trace(timeStr);
        Trace(" Timer  " + mId + " started.\n");
    }
    
    // Return the elapsed seconds since the timer was started
    int SecondsSinceStart()
    {
        // Get current time
        return Now() - mReferenceTime;
    }
    
    // The reference time for this timer
    int mReferenceTime;
    // The timer ID for this timer (needed for debug messages only)
    uint mId;
};

