﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MemBrainLib;

namespace MemBrainLibUsageExample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void But_UseLib_Click(object sender, EventArgs e)
        {
            const int START_X = 1000;
            const int START_Y = 2000;
            const int DELTA_X = 60;
            const int DELTA_Y = 180;
            const int IN_COUNT = 10;
            const int HID_LAYER_COUNT = 4;
            const int HID_LAYER_SIZE = 5;
            const int OUT_COUNT = 3;

            int posX = START_X;
            int posY = START_Y;

            // Create a new net
            NeuralNet net = new NeuralNet();

            // Add input neurons
            for (int i = 0; i < IN_COUNT; i++)
            {
                string name = "In " + i.ToString();
                net.AddInput(posX, posY, name);
                posX += DELTA_X;
            }

            // Add hidden neurons
            int hidStartX = START_X + ((posX - DELTA_X) - START_X) / 2 - (HID_LAYER_SIZE / 2 - 1) * DELTA_X;
            int outStartX = START_X + ((posX - DELTA_X) - START_X) / 2 - (OUT_COUNT / 2 - 1) * DELTA_X + 1;

            for (int i = 0; i < HID_LAYER_COUNT; i++)
            {
                posY += DELTA_Y;
                posX = hidStartX;
                for (int j = 0; j < HID_LAYER_SIZE; j++)
                {
                    string name = "Hid " + j.ToString();
                    net.AddHidden(posX, posY, name);
                    posX += DELTA_X;
                }
            }

            // Add output neurons
            posX = outStartX;
            posY += DELTA_Y;

            for (int i = 0; i < OUT_COUNT; i++)
            {
                string name = "Out " + i.ToString();
                net.AddOutput(posX, posY, name);
                posX += DELTA_X;
            }

            // Connect all inputs to the first hidden layer.
            // Note: The hidden neurons are currently all in the 'unresolved' layer since their outputs
            // haven't been connected so far. Thus, the first <HID_LAYER_SIZE> hidden neurons will become 
            // the first hidden layer now.

            // Select all input neurons
            net.SelectInput(false);
            // Apply Extra Selection to them
            net.ExtraSelection();
            // Reset the selection
            net.ClearSelection();

            // Select the first hidden layer (i.e. the first <HID_LAYER_SIZE> neurons of the 'unresolved' layer)
            for (int i = 0; i < HID_LAYER_SIZE; i++)
            {
                net.SelectUnresolved(i, true);
            }

            // Connect the selected neurons FROM the extra selected input layer 
            net.ConnectFromExtra();
            
            // Now apply Extra Selection to the still selected first hidden layer and reset the selection
            net.ExtraSelection();
            net.ClearSelection();

            // Now interconnect the hidden layers one by one. Note that hidden neurons will be assigned to a hidden layer 
            // once their outputs are connected. 
            for (int i = 0; i < HID_LAYER_COUNT - 1; i++)
            {
                for (int j = 0; j < HID_LAYER_SIZE; j++)
                {
                    net.SelectUnresolved(j, true);
                }
                net.ConnectFromExtra();
                net.ExtraSelection();
                net.ClearSelection();
            }

            // Select all output neurons and apply Extra Selection to them
            net.SelectOutput(false);
            net.ExtraSelection();

            // Select the remaining unresolved neurons. These are the neurons of the last hidden layer 
            // (their outputs are still unconnected)
            net.SelectUnresolved(false);
            
            // Connect them to the output layer
            net.ConnectToExtra();

            // Now also add links from the first hidden layer to the output neurons
            net.SelectHidden(0, false);
            net.ConnectToExtra();

            net.Randomize();

            String fileName = "EditSequenceTest.mbn";

            if (net.SaveAs(fileName))
            {
                MessageBox.Show("The newly created net has been saved with the name '" + fileName + "'.");
            }
            else
            {
                MessageBox.Show("Error: Unable to save newly created net!");
            }
        }

        private void But_GetDllVersion_Click(object sender, EventArgs e)
        {
            string version = MemBrain.GetVersionInfo();

            MessageBox.Show(version);
        }
    }
}
