﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MemBrainLib
{
    /// <summary>
    /// This fully static class represents the MemBrain instance.
    /// All functions that can not be assigned to a specific net or lesson are represented 
    /// here as static interfaces.
    /// </summary>
    public class MemBrain : MB_DLL
    {
        /// Get the version information string of the DLL.
        /// Specify maximum length of string to be copied (excluding the terminating '\0'.
        /// A terminating '\0' will be attached in every case.
        public static string GetVersionInfo()
        {
            string s;

            if (MB_GetVersionInfo(out s))
            {
                return s;
            }
            else
            {
                return "Unable to retrieve version info from MemBrain dll!";
            }
        }
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public static bool LoadTeacherFile(string fileName)
        {
            return MB_LoadTeacherFile(fileName);
        }

        /// <summary>
        /// Select the active teacher by name.
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public static bool SelectTeacher(string name)
        {
            return MB_SelectTeacher(name);
        }

        /// <summary>
        /// Get number of available teachers
        /// </summary>
        /// <returns></returns>
        public static int GetTeacherCount()
        {
            return MB_GetTeacherCount();
        }

        /// <summary>
        /// Get the name of the teacher at the current index
        /// </summary>
        /// <param name="idx"></param>
        /// <returns></returns>
        public static string GetTeacherName(int idx)
        {
            string name;

            if (MB_GetTeacherName(idx, out name))
            {
                return name.ToString();
            }
            else
            {
                return "";
            }
        }

        /// <summary>
        /// Get the nearest grid point to a given point        
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <param name="gridX"></param>
        /// <param name="gridY"></param>
        /// <returns></returns>
        public static bool GetGridPoint(int x, int y, out int gridX, out int gridY)
        {
            return MB_GetGridPoint(x, y, out gridX, out gridY);
        }

        /// Get the adjusted grid width 
        public static int GetGridWidth()
        {
            return MB_GetGridWidth();
        }

        /// Get a random value between 0 an 1       
        public static double Random()
        {
            return MB_Random();
        }

        /// Get the separators used for CSV file parsing
        public static bool GetCsvFileSeparators(out string listSep, out string decSep)
        {
            return MB_GetCsvFileSeparators(out listSep, out decSep);
        }

        /// Set the separators used for CSV file parsing
        public static bool SetCsvFileSeparators(string listSep, string decSep)
        {
            return MB_SetCsvFileSeparators(listSep, decSep);
        }
		
		/// Set password for opening files (nets or lessons) 
        public static bool SetFileOpenPwd(string pwd)
        {
            return MB_SetFileOpenPwd(pwd);
        }

        /// Remove password for opening files (nets or lessons) 
        public static void RemoveFileOpenPwd()
        {
            MB_RemoveFileOpenPwd();
        }
    }
}
